package com.ejie.aa17a.dao.impl;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.sql.DataSource;

import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.aa17a.dao.iface.Aa17aDatoHorarioDao;
import com.ejie.aa17a.model.Aa17aContaminante;
import com.ejie.aa17a.model.Aa17aDatoHorario;
import com.ejie.aa17a.utilidades.Aa17aFuncionesComunes;

/**
 * Aa17aDatoHorarioDaoImpl generated by UDA, 18-dic-2013 15:36:14.
 * 
 * @author UDA
 */

@Transactional
public class Aa17aDatoHorarioDaoImpl implements Aa17aDatoHorarioDao {
	private JdbcTemplate jdbcTemplate;
	private RowMapper<Aa17aDatoHorario> rwMap = new RowMapper<Aa17aDatoHorario>() {
		public Aa17aDatoHorario mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {

			Aa17aDatoHorario datoHorario = new Aa17aDatoHorario();
			datoHorario.setIdEstacion(resultSet.getLong("IDESTACION"));
			datoHorario.setNombreEstacion(resultSet.getString("NOMESTACION"));

			Aa17aContaminante contaminante = new Aa17aContaminante();
			contaminante.setIdContaminante(resultSet.getLong("IDCONTAMINANTE"));
			contaminante.setNombreContaminante(resultSet.getString("NOMCONTAMINANTE"));
			contaminante.setUnidadMedida(resultSet.getString("UNIDADMEDIDA"));
			contaminante.setTipoParametro(resultSet.getInt("TIPOPARAMETRO"));
			contaminante.setTipoCalculoICA(resultSet.getInt("TIPOCALCULO"));

			datoHorario.setContaminante(contaminante);

			datoHorario.setFechaDato(resultSet.getDate("FECHADATO"));

			datoHorario.setValorHora01(resultSet.getBigDecimal("VALORHORA01"));
			datoHorario.setValorHora02(resultSet.getBigDecimal("VALORHORA02"));
			datoHorario.setValorHora03(resultSet.getBigDecimal("VALORHORA03"));
			datoHorario.setValorHora04(resultSet.getBigDecimal("VALORHORA04"));
			datoHorario.setValorHora05(resultSet.getBigDecimal("VALORHORA05"));
			datoHorario.setValorHora06(resultSet.getBigDecimal("VALORHORA06"));
			datoHorario.setValorHora07(resultSet.getBigDecimal("VALORHORA07"));
			datoHorario.setValorHora08(resultSet.getBigDecimal("VALORHORA08"));
			datoHorario.setValorHora09(resultSet.getBigDecimal("VALORHORA09"));
			datoHorario.setValorHora10(resultSet.getBigDecimal("VALORHORA10"));
			datoHorario.setValorHora11(resultSet.getBigDecimal("VALORHORA11"));
			datoHorario.setValorHora12(resultSet.getBigDecimal("VALORHORA12"));
			datoHorario.setValorHora13(resultSet.getBigDecimal("VALORHORA13"));
			datoHorario.setValorHora14(resultSet.getBigDecimal("VALORHORA14"));
			datoHorario.setValorHora15(resultSet.getBigDecimal("VALORHORA15"));
			datoHorario.setValorHora16(resultSet.getBigDecimal("VALORHORA16"));
			datoHorario.setValorHora17(resultSet.getBigDecimal("VALORHORA17"));
			datoHorario.setValorHora18(resultSet.getBigDecimal("VALORHORA18"));
			datoHorario.setValorHora19(resultSet.getBigDecimal("VALORHORA19"));
			datoHorario.setValorHora20(resultSet.getBigDecimal("VALORHORA20"));
			datoHorario.setValorHora21(resultSet.getBigDecimal("VALORHORA21"));
			datoHorario.setValorHora22(resultSet.getBigDecimal("VALORHORA22"));
			datoHorario.setValorHora23(resultSet.getBigDecimal("VALORHORA23"));
			datoHorario.setValorHora24(resultSet.getBigDecimal("VALORHORA24"));

			return datoHorario;
		}
	};

	private RowMapper<Date> rwMapFecha = new RowMapper<Date>() {
		public Date mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {

			if (null != resultSet.getTimestamp("FECHA")) {
				return new Date(resultSet.getTimestamp("FECHA").getTime());
			}
			else {
				return null;
			}

		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */

	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/**
	 * Finds a List of rows in the Aa17aDatoHorario table.
	 * 
	 * @param aa17adatohorario
	 *            Aa17aDatoHorario
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Aa17aDatoHorario> findAll(Aa17aDatoHorario aa17adatohorario) {
		StringBuilder query = new StringBuilder();
		query.append("SELECT  t1.T01_ESTACION_ID IDESTACION,t1.T02_CONTAMINANTE_ID IDCONTAMINANTE,t1.T07_FECHA FECHADATO, ");
		query.append(" t1.T07_VALOR_HORA_24 VALORHORA24,t1.T07_VALOR_HORA_01 VALORHORA01,t1.T07_VALOR_HORA_02 VALORHORA02, ");
		query.append(" t1.T07_VALOR_HORA_03 VALORHORA03,t1.T07_VALOR_HORA_04 VALORHORA04,t1.T07_VALOR_HORA_05 VALORHORA05, ");
		query.append(" t1.T07_VALOR_HORA_06 VALORHORA06,t1.T07_VALOR_HORA_07 VALORHORA07,t1.T07_VALOR_HORA_08 VALORHORA08, ");
		query.append(" t1.T07_VALOR_HORA_09 VALORHORA09,t1.T07_VALOR_HORA_10 VALORHORA10,t1.T07_VALOR_HORA_11 VALORHORA11, ");
		query.append(" t1.T07_VALOR_HORA_12 VALORHORA12,t1.T07_VALOR_HORA_13 VALORHORA13,t1.T07_VALOR_HORA_14 VALORHORA14, ");
		query.append(" t1.T07_VALOR_HORA_15 VALORHORA15,t1.T07_VALOR_HORA_16 VALORHORA16,t1.T07_VALOR_HORA_17 VALORHORA17, ");
		query.append(" t1.T07_VALOR_HORA_18 VALORHORA18,t1.T07_VALOR_HORA_19 VALORHORA19,t1.T07_VALOR_HORA_20 VALORHORA20, ");
		query.append(" t1.T07_VALOR_HORA_21 VALORHORA21,t1.T07_VALOR_HORA_22 VALORHORA22,t1.T07_VALOR_HORA_23 VALORHORA23, ");
		query.append(" AA1702S00.T02_NOMBRE AS NOMCONTAMINANTE, ");
		query.append(" AA1701S00.T01_NOMBRE || ' (' || T01_DIRECCION || ')' AS NOMESTACION, ");
		query.append(" AA1702S00.T02_UNIDAD_MEDIDA UNIDADMEDIDA, ");
		query.append(" AA1702S00.T02_TIPO_PARAMETRO TIPOPARAMETRO, ");
		query.append(" AA1702S00.T02_TIPO_CALCULO_ID TIPOCALCULO ");
		query.append(" FROM AA1707S00 t1 ");
		query.append(" INNER JOIN AA1702S00 ON AA1702S00.T02_CONTAMINANTE_ID = T1.T02_CONTAMINANTE_ID ");
		query.append(" INNER JOIN AA1701S00 ON AA1701S00.T01_ESTACION_ID = t1.T01_ESTACION_ID ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(aa17adatohorario);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		query.append(" ORDER BY t1.T07_FECHA ASC, NOMCONTAMINANTE ASC ");

		List<?> params = (List<?>) mapaWhere.get("params");

		return (List<Aa17aDatoHorario>) this.jdbcTemplate.query(
				query.toString(), this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the Aa17aDatoHorario table.
	 * 
	 * @param aa17adatohorario
	 *            Aa17aDatoHorario
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(Aa17aDatoHorario aa17adatohorario) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM AA17A.AA1707S00 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(aa17adatohorario);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Devuelve la fecha de la ultima medicion de una estacion
	 * 
	 * @param aa17adatohorario
	 *            Aa17aDatoHorario
	 * @return Date
	 */
	@Transactional(readOnly = true)
	public Date getUltimaFechaMedida(Aa17aDatoHorario aa17adatohorario) {

		StringBuilder query = new StringBuilder();

		query.append("SELECT MAX(t1.T07_FECHA) FECHA FROM AA1707S00 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(aa17adatohorario);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return (Date) this.jdbcTemplate.queryForObject(query.toString(), this.rwMapFecha, params.toArray());
	}

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Aa17aDatoHorario entity
	 * 
	 * @param aa17adatohorario
	 *            Aa17aDatoHorario Bean with the criteria values to filter by.
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap(Aa17aDatoHorario aa17adatohorario) {

		StringBuffer where = new StringBuffer(
				Aa17aDatoHorarioDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (aa17adatohorario != null
				&& aa17adatohorario.getIdEstacion() != null) {
			where.append(" AND t1.T01_ESTACION_ID = ?");
			params.add(aa17adatohorario.getIdEstacion());
		}

		if (aa17adatohorario.getListaContaminantes() != null && aa17adatohorario.getListaContaminantes().size() > 0) {
			where.append(" AND t1.T02_CONTAMINANTE_ID IN ");
			where.append(" ( ");
			String separador = "";

			for (Long dato : aa17adatohorario.getListaContaminantes()) {
				where.append(separador);
				where.append(dato);
				separador = ",";
			}
			where.append(" ) ");
		}

		if (aa17adatohorario != null && aa17adatohorario.getFechaDato() != null) {
			where.append(" AND t1.T07_FECHA = ?");
			params.add(aa17adatohorario.getFechaDato());
		}

		//rango de fechas desde y hasta para el informe de datos historicos
		if (aa17adatohorario != null && aa17adatohorario.getFechaDesde() != null) {
			where.append(" AND t1.T07_FECHA >= ?");
			params.add(aa17adatohorario.getFechaDesde());
		}

		if (aa17adatohorario != null && aa17adatohorario.getFechaHasta() != null) {
			where.append(" AND t1.T07_FECHA <= ?");
			params.add(Aa17aFuncionesComunes.getDateHora(aa17adatohorario.getFechaHasta()));
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;
}
